IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_CREDITO_ICMS_ST_PIS_COFINS]'))
	DROP TRIGGER [dbo].[TRG_CREDITO_ICMS_ST_PIS_COFINS]
GO


CREATE TRIGGER TRG_CREDITO_ICMS_ST_PIS_COFINS
ON EST_NF_ENT_IT
AFTER INSERT
AS
BEGIN    
    DECLARE @Contagem INT;

    -- Contar o nmero de registros com base nas condies especificadas
    SELECT @Contagem = COUNT(*)
    FROM
        INSERTED IT
        INNER JOIN GLB_NT_OP AS OP ON OP.CD_NT_OP = IT.CD_NT_OP
        LEFT OUTER JOIN EST_NF_ENT_DAR_IT AS D ON IT.CD_EMP = D.CD_EMP
            AND IT.CD_FILIAL = D.CD_FILIAL
            AND IT.CD_NF = D.CD_NF
            AND IT.CD_PROD = D.CD_PROD
    WHERE
        FLAG_DEDUZ_ICMS_RET_BASE_PIS_COFINS_SAIDA = 1
        OR FLAG_DEDUZ_FCP_BASE_PIS_COFINS_SAIDA = 1
        OR FLAG_DEDUZ_FCP_RET_BASE_PIS_COFINS_SAIDA = 1
        OR FLAG_DEDUZ_ICMS_EFET_BASE_PIS_COFINS_SAIDA = 1
        OR FLAG_DEDUZ_ICMS_ST_DARE_BASE_PIS_COFINS_SAIDA = 1
        OR FLAG_DEDUZ_ICMS_ST_BASE_PIS_COFINS_SAIDA = 1
        OR FLAG_DEDUZ_FCP_ST_BASE_PIS_COFINS_SAIDA = 1;

    -- Verificar se existem registros para realizar a insero
    IF @Contagem > 0
    BEGIN
        -- Inserir registros na tabela de destino se eles ainda no existirem
        INSERT INTO EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS (
            CD_EMP,
            CD_FILIAL,
            CD_NF,
            CD_PROD,
			QT_IT,
            VLR_ICMS_ST_DARE,
            VLR_ICMS_EFETIVO,
            VLR_ICMS_SUBS,
            VLR_ICMS_RET,
            VLR_FECOP,
            VLR_FECOP_RET,
            VLR_FECOP_ST,
            SALDO_ZERADO
        )
        SELECT
            IT.CD_EMP, 
            IT.CD_FILIAL, 
            IT.CD_NF, 
            IT.CD_PROD,
			IT.QT_IT,
            CASE WHEN FLAG_DEDUZ_ICMS_ST_DARE_BASE_PIS_COFINS_SAIDA = 1 THEN COALESCE(D.VLR_ICMS_SUBS, 0) ELSE 0 END AS VLR_ICMS_ST_DARE, 
            0 AS VLR_ICMS_EFETIVO, 
            CASE WHEN FLAG_DEDUZ_ICMS_ST_BASE_PIS_COFINS_SAIDA = 1 THEN COALESCE(IT.VLR_ICMS_SUBS, 0) ELSE 0 END AS VLR_ICMS_SUBS, 
            CASE WHEN FLAG_DEDUZ_ICMS_RET_BASE_PIS_COFINS_SAIDA = 1 THEN COALESCE(IT.VLR_ICMS_RET, 0) ELSE 0 END AS VLR_ICMS_RET,         
            CASE WHEN FLAG_DEDUZ_FCP_BASE_PIS_COFINS_SAIDA = 1 THEN COALESCE(IT.VLR_FECOP, 0) ELSE 0 END AS VLR_FECOP,  
            CASE WHEN FLAG_DEDUZ_FCP_RET_BASE_PIS_COFINS_SAIDA = 1 THEN COALESCE(IT.VLR_FECOP_RET, 0) ELSE 0 END AS VLR_FECOP_RET,  
            CASE WHEN FLAG_DEDUZ_FCP_ST_BASE_PIS_COFINS_SAIDA = 1 THEN COALESCE(IT.VLR_FECOP_ST, 0) ELSE 0 END AS VLR_FECOP_ST,  
            0 AS SALDO_ZERADO
        FROM
            INSERTED IT
            INNER JOIN GLB_NT_OP AS OP ON OP.CD_NT_OP = IT.CD_NT_OP
            LEFT OUTER JOIN EST_NF_ENT_DAR_IT AS D ON IT.CD_EMP = D.CD_EMP
                AND IT.CD_FILIAL = D.CD_FILIAL
                AND IT.CD_NF = D.CD_NF
                AND IT.CD_PROD = D.CD_PROD
        WHERE
            (FLAG_DEDUZ_ICMS_RET_BASE_PIS_COFINS_SAIDA = 1
            OR FLAG_DEDUZ_FCP_BASE_PIS_COFINS_SAIDA = 1
            OR FLAG_DEDUZ_FCP_RET_BASE_PIS_COFINS_SAIDA = 1
            OR FLAG_DEDUZ_ICMS_EFET_BASE_PIS_COFINS_SAIDA = 1
            OR FLAG_DEDUZ_ICMS_ST_DARE_BASE_PIS_COFINS_SAIDA = 1
            OR FLAG_DEDUZ_ICMS_ST_BASE_PIS_COFINS_SAIDA = 1
            OR FLAG_DEDUZ_FCP_ST_BASE_PIS_COFINS_SAIDA = 1)
            AND NOT EXISTS (
                SELECT 1 
                FROM EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS AS CREDITO
                WHERE 
                    IT.CD_EMP = CREDITO.CD_EMP
                    AND IT.CD_FILIAL = CREDITO.CD_FILIAL
                    AND IT.CD_NF = CREDITO.CD_NF
                    AND IT.CD_PROD = CREDITO.CD_PROD
            )
			AND ((COALESCE(D.VLR_ICMS_SUBS, 0) + COALESCE(IT.VLR_ICMS_SUBS, 0) + COALESCE(IT.VLR_ICMS_RET, 0) + COALESCE(IT.VLR_FECOP, 0) + COALESCE(IT.VLR_FECOP_RET, 0) + COALESCE(IT.VLR_FECOP_ST, 0)) > 0)
			;
    END
    ELSE
    BEGIN
        PRINT 'Nenhum registro encontrado que atenda aos critrios.';
    END
END;